VERSION 5.00
Begin VB.Form frmAutoClan 
   BackColor       =   &H00000000&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Automatic Clan Management"
   ClientHeight    =   5085
   ClientLeft      =   45
   ClientTop       =   360
   ClientWidth     =   5865
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H00FFFFFF&
   Icon            =   "frmAutoClan.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5085
   ScaleWidth      =   5865
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame fraSettings 
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      ForeColor       =   &H00FFFFFF&
      Height          =   3135
      Left            =   0
      TabIndex        =   1
      Top             =   1800
      Width           =   5895
      Begin VB.TextBox txtAlternates 
         Appearance      =   0  'Flat
         BackColor       =   &H002A2A2A&
         ForeColor       =   &H00FFFFFF&
         Height          =   2775
         Left            =   3000
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   6
         Top             =   360
         Width           =   2535
      End
      Begin VB.TextBox txtPreferred 
         Appearance      =   0  'Flat
         BackColor       =   &H002A2A2A&
         ForeColor       =   &H00FFFFFF&
         Height          =   2775
         Left            =   120
         MultiLine       =   -1  'True
         TabIndex        =   5
         Top             =   360
         Width           =   2535
      End
      Begin VB.Line linTextWrapper 
         BorderColor     =   &H00FFFFFF&
         Index           =   0
         X1              =   0
         X2              =   600
         Y1              =   0
         Y2              =   0
      End
      Begin VB.Label Label2 
         BackColor       =   &H00000000&
         BackStyle       =   0  'Transparent
         Caption         =   "Alternate Shamans"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FFFFFF&
         Height          =   255
         Left            =   3000
         TabIndex        =   4
         Top             =   120
         Width           =   2175
      End
      Begin VB.Label Label1 
         BackColor       =   &H00000000&
         BackStyle       =   0  'Transparent
         Caption         =   "Preferred Shamans"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FFFFFF&
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   120
         Width           =   2175
      End
   End
   Begin VB.CheckBox chkOn 
      BackColor       =   &H00000000&
      Caption         =   "Use automatic clan management."
      ForeColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   1440
      Width           =   5655
   End
   Begin VB.Label lblExplanation 
      BackStyle       =   0  'Transparent
      Caption         =   $"frmAutoClan.frx":000C
      ForeColor       =   &H00FFFFFF&
      Height          =   1215
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   5655
   End
End
Attribute VB_Name = "frmAutoClan"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub chkOn_Click()
    Dim Value As Boolean
    Value = CheckToBool(chkOn.Value)
    autoClanEnabled = Value
    
    If (AutoRedraw) Then
        If (Value) Then
            Height = Height + fraSettings.Height
        Else
            Height = Height - fraSettings.Height
        End If
    End If
    
    If (Value) Then
        If (AutoClan.PreferredCount = 0) Then
            BootstrapPreferred
            SaveAutoClanUsers
        End If
        FillBoxes
    End If
    
    WriteBoolean "Enabled", Value, "AutoClan"
End Sub

Private Sub BootstrapPreferred()
On Error GoTo Trap
    Dim Members() As ClanMember, i As Long
    
    UserClan.GetMembers Members
    
    For i = LBound(Members) To UBound(Members)
        If (Members(i).Rank = rankShaman) Then
            AutoClan.AddPreferred Members(i).Username
        End If
    Next i
Trap:
End Sub

Private Sub FillBoxes()
    If (AutoClan Is Nothing) Then Exit Sub
    
    If (AutoClan.PreferredCount > 0) Then _
        FillBox txtPreferred, AutoClan.Preferred
    If (AutoClan.AlternateCount > 0) Then _
        FillBox txtAlternates, AutoClan.Alternates
End Sub

Private Sub FillBox(T As TextBox, Users() As String)
    Dim i As Long
    T.Text = ""
    
    For i = LBound(Users) To UBound(Users)
        If (i = UBound(Users)) Then
            T.Text = T.Text & Users(i)
        Else
            T.Text = T.Text & Users(i) & vbNewLine
        End If
    Next i
End Sub

Private Sub Form_Load()
    AutoRedraw = False
    autoClanEnabled = GetBoolean("Enabled", "AutoClan", False) 'reload
    chkOn.Value = BoolToCheck(autoClanEnabled)
    If (Not autoClanEnabled) Then
        Height = Height - fraSettings.Height
    End If
    AutoRedraw = True
    WrapControl txtPreferred
    WrapControl txtAlternates
    FillBoxes
End Sub

Private Sub Save()
    WriteConfig "Preferred", BuildUserList(txtPreferred), "AutoClan"
    WriteConfig "Alternates", BuildUserList(txtAlternates), "AutoClan"
    LoadAutoClanUsers
End Sub

Private Function BuildUserList(T As TextBox) As String
    Dim Lines() As String, i As Long
    Lines = Split(T.Text, vbNewLine)
    
    For i = LBound(Lines) To UBound(Lines)
        BuildUserList = BuildUserList & Lines(i) & " "
    Next i
End Function

Private Sub WrapControl(C As Control)
    Dim i As Long
    
    AutoRedraw = False
    
    If (linTextWrapper.UBound = 0) Then
        i = 0
        
        Load linTextWrapper(1)
        Load linTextWrapper(2)
        Load linTextWrapper(3)
    Else
        i = linTextWrapper.UBound + 1
        
        Load linTextWrapper(i)
        Load linTextWrapper(i + 1)
        Load linTextWrapper(i + 2)
        Load linTextWrapper(i + 3)
    End If
    
    With linTextWrapper(i)
        .x1 = C.Left - 15
        .X2 = C.Left - 15
        .y1 = C.Top - 15
        .Y2 = C.Top + C.Height + 30
        .Visible = True
        If (i > 0) Then _
            .BorderColor = linTextWrapper(i).BorderColor
    End With
    
    With linTextWrapper(i + 1)
        .x1 = C.Left - 15
        .X2 = C.Left + C.Width + 30
        .y1 = C.Top - 15
        .Y2 = C.Top - 15
        .BorderColor = linTextWrapper(i).BorderColor
        .Visible = True
    End With
    
    With linTextWrapper(i + 2)
        .x1 = C.Left + C.Width + 30
        .X2 = C.Left + C.Width + 30
        .y1 = C.Top - 15
        .Y2 = C.Top + C.Height + 30
        .BorderColor = linTextWrapper(i).BorderColor
        .Visible = True
    End With
    
    With linTextWrapper(i + 2)
        .x1 = C.Left - 15
        .X2 = C.Left + C.Width + 30
        .y1 = C.Top + C.Height + 30
        .Y2 = C.Top + C.Height + 30
        .BorderColor = linTextWrapper(i).BorderColor
        .Visible = True
    End With
    
    AutoRedraw = True
    Refresh
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Save
End Sub

Private Sub txtAlternates_LostFocus()
    Save
End Sub

Private Sub txtPreferred_KeyPress(KeyAscii As Integer)
    If (KeyAscii = vbKeyReturn) Then
        If (txtPreferred.Text = "") Then Exit Sub
        Debug.Print UBound(Split(txtPreferred.Text, vbNewLine))
        If (UBound(Split(txtPreferred.Text, vbNewLine)) >= 4) Then
            KeyAscii = 0
            Exit Sub
        End If
    End If
End Sub

Private Sub txtPreferred_LostFocus()
    Save
End Sub
